/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.streams.AbstractStreamWriter;
import org.glassfish.grizzly.streams.BufferedOutput;

public final class DefaultStreamWriter
extends AbstractStreamWriter {
    public DefaultStreamWriter(Connection connection) {
        super(connection, new Output(connection));
    }

    @Override
    public GrizzlyFuture<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return super.flush(new ResetCounterCompletionHandler((Output)this.output, completionHandler));
    }

    private static final class ResetCounterCompletionHandler
    implements CompletionHandler<Integer> {
        private final Output output;
        private final CompletionHandler<Integer> parentCompletionHandler;

        public ResetCounterCompletionHandler(Output output, CompletionHandler<Integer> parentCompletionHandler) {
            this.output = output;
            this.parentCompletionHandler = parentCompletionHandler;
        }

        @Override
        public void cancelled() {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.cancelled();
            }
        }

        @Override
        public void failed(Throwable throwable2) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.failed(throwable2);
            }
        }

        @Override
        public void completed(Integer result2) {
            this.output.sentBytesCounter = 0;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.completed(result2);
            }
        }

        @Override
        public void updated(Integer result2) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.updated(result2);
            }
        }
    }

    private static final class CompletionHandlerAdapter
    implements CompletionHandler<WriteResult<Buffer, SocketAddress>> {
        private final Output output;
        private final FutureImpl<Integer> future;
        private final CompletionHandler<Integer> completionHandler;

        public CompletionHandlerAdapter(Output output, FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler) {
            this.output = output;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void cancelled() {
            if (this.completionHandler != null) {
                this.completionHandler.cancelled();
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        @Override
        public void failed(Throwable throwable2) {
            if (this.completionHandler != null) {
                this.completionHandler.failed(throwable2);
            }
            if (this.future != null) {
                this.future.failure(throwable2);
            }
        }

        @Override
        public void completed(WriteResult result2) {
            this.output.sentBytesCounter = (int)((long)this.output.sentBytesCounter + result2.getWrittenSize());
            int totalSentBytes = this.output.sentBytesCounter;
            if (this.completionHandler != null) {
                this.completionHandler.completed(totalSentBytes);
            }
            if (this.future != null) {
                this.future.result(totalSentBytes);
            }
        }

        @Override
        public void updated(WriteResult result2) {
            if (this.completionHandler != null) {
                this.completionHandler.updated(this.output.sentBytesCounter + (int)result2.getWrittenSize());
            }
        }
    }

    public static final class Output
    extends BufferedOutput {
        private final Connection connection;
        private int sentBytesCounter;

        public Output(Connection connection) {
            super(connection.getWriteBufferSize());
            this.connection = connection;
        }

        @Override
        protected GrizzlyFuture<Integer> flush0(Buffer buffer, CompletionHandler<Integer> completionHandler) throws IOException {
            SafeFutureImpl<Integer> future = SafeFutureImpl.create();
            if (buffer == null) {
                buffer = Buffers.EMPTY_BUFFER;
            }
            this.connection.write(buffer, new CompletionHandlerAdapter(this, future, completionHandler));
            return future;
        }

        @Override
        protected Buffer newBuffer(int size2) {
            return this.connection.getTransport().getMemoryManager().allocate(size2);
        }

        @Override
        protected Buffer reallocateBuffer(Buffer oldBuffer, int size2) {
            return this.connection.getTransport().getMemoryManager().reallocate(oldBuffer, size2);
        }

        @Override
        protected void onClosed() throws IOException {
            this.connection.closeSilently();
        }
    }
}

